/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.betternether.BN;
import org.betterx.betternether.registry.NetherEntities;
import org.betterx.betternether.registry.NetherFeatures;
import org.betterx.betternether.registry.NetherStructures;
import org.betterx.betternether.world.NetherBiome;
import org.betterx.betternether.world.NetherBiomeBuilder;
import org.betterx.betternether.world.NetherBiomeConfig;
import org.betterx.betternether.world.biomes.CrimsonGlowingWoods;
import org.betterx.betternether.world.biomes.CrimsonPinewood;
import org.betterx.betternether.world.biomes.FloodedDeltas;
import org.betterx.betternether.world.biomes.NetherBoneReef;
import org.betterx.betternether.world.biomes.NetherGrasslands;
import org.betterx.betternether.world.biomes.NetherGravelDesert;
import org.betterx.betternether.world.biomes.NetherJungle;
import org.betterx.betternether.world.biomes.NetherMagmaLand;
import org.betterx.betternether.world.biomes.NetherMushroomForest;
import org.betterx.betternether.world.biomes.NetherMushroomForestEdge;
import org.betterx.betternether.world.biomes.NetherPoorGrasslands;
import org.betterx.betternether.world.biomes.NetherSoulPlain;
import org.betterx.betternether.world.biomes.NetherSulfuricBoneReef;
import org.betterx.betternether.world.biomes.NetherSwampland;
import org.betterx.betternether.world.biomes.NetherSwamplandTerraces;
import org.betterx.betternether.world.biomes.NetherWartForest;
import org.betterx.betternether.world.biomes.NetherWartForestEdge;
import org.betterx.betternether.world.biomes.OldFungiwoods;
import org.betterx.betternether.world.biomes.OldSwampland;
import org.betterx.betternether.world.biomes.OldWarpedWoods;
import org.betterx.betternether.world.biomes.UpsideDownForest;
import org.betterx.betternether.world.biomes.UpsideDownForestCleared;

public class NetherBiomes {
    public static final List<NetherBiome> ALL_BN_BIOMES = new ArrayList<NetherBiome>(21);
    public static final BCLBiome BIOME_GRAVEL_DESERT = NetherBiomes.registerNetherBiome(Config.BIOME_GRAVEL_DESERT);
    public static final BCLBiome BIOME_NETHER_JUNGLE = NetherBiomes.registerNetherBiome(Config.BIOME_NETHER_JUNGLE);
    public static final BCLBiome BIOME_WART_FOREST = NetherBiomes.registerNetherBiome(Config.BIOME_WART_FOREST, Config.BIOME_WART_FOREST_EDGE);
    public static final BCLBiome BIOME_GRASSLANDS = NetherBiomes.registerNetherBiome(Config.BIOME_GRASSLANDS);
    public static final BCLBiome BIOME_MUSHROOM_FOREST = NetherBiomes.registerNetherBiome(Config.BIOME_MUSHROOM_FOREST, Config.BIOME_MUSHROOM_FOREST_EDGE);
    public static final BCLBiome BIOME_MUSHROOM_FOREST_EDGE = BIOME_MUSHROOM_FOREST.getEdge();
    public static final BCLBiome BIOME_WART_FOREST_EDGE = BIOME_WART_FOREST.getEdge();
    public static final BCLBiome BIOME_BONE_REEF = NetherBiomes.registerNetherBiome(Config.BIOME_BONE_REEF);
    public static final BCLBiome BIOME_SULFURIC_BONE_REEF = NetherBiomes.registerSubBiome(Config.BIOME_SULFURIC_BONE_REEF, BIOME_BONE_REEF);
    public static final BCLBiome BIOME_POOR_GRASSLANDS = NetherBiomes.registerSubBiome(Config.BIOME_POOR_GRASSLANDS, BIOME_GRASSLANDS);
    public static final BCLBiome NETHER_SWAMPLAND = NetherBiomes.registerNetherBiome(Config.NETHER_SWAMPLAND);
    public static final BCLBiome NETHER_SWAMPLAND_TERRACES = NetherBiomes.registerSubBiome(Config.NETHER_SWAMPLAND_TERRACES, NETHER_SWAMPLAND);
    public static final BCLBiome MAGMA_LAND = NetherBiomes.registerNetherBiome(Config.MAGMA_LAND);
    public static final BCLBiome SOUL_PLAIN = NetherBiomes.registerSubBiome(Config.SOUL_PLAIN, BIOME_WART_FOREST);
    public static final BCLBiome CRIMSON_GLOWING_WOODS = NetherBiomes.registerSubBiome(Config.CRIMSON_GLOWING_WOODS, BiomeAPI.CRIMSON_FOREST_BIOME);
    public static final BCLBiome OLD_WARPED_WOODS = NetherBiomes.registerSubBiome(Config.OLD_WARPED_WOODS, BiomeAPI.WARPED_FOREST_BIOME);
    public static final BCLBiome CRIMSON_PINEWOOD = NetherBiomes.registerSubBiome(Config.CRIMSON_PINEWOOD, BiomeAPI.CRIMSON_FOREST_BIOME);
    public static final BCLBiome OLD_FUNGIWOODS = NetherBiomes.registerSubBiome(Config.OLD_FUNGIWOODS, BIOME_MUSHROOM_FOREST);
    public static final BCLBiome FLOODED_DELTAS = NetherBiomes.registerSubBiome(Config.FLOODED_DELTAS, BiomeAPI.BASALT_DELTAS_BIOME);
    public static final BCLBiome UPSIDE_DOWN_FOREST = NetherBiomes.registerNetherBiome(Config.UPSIDE_DOWN_FOREST);
    public static final BCLBiome UPSIDE_DOWN_FOREST_CLEARED = NetherBiomes.registerNetherBiome(Config.UPSIDE_DOWN_FOREST_CLEARED);
    public static final BCLBiome OLD_SWAMPLAND = NetherBiomes.registerSubBiome(Config.OLD_SWAMPLAND, NETHER_SWAMPLAND);
    public static boolean useLegacyGeneration = false;

    public static void register() {
        BCLBiomeRegistry.registerBiomeCodec((class_2960)BN.id("biome"), NetherBiome.KEY_CODEC);
        BiomeAPI.registerNetherBiomeModification((biomeID, biome) -> {
            if (!biomeID.method_12836().equals("betternether")) {
                NetherEntities.modifyNonBNBiome(biomeID, (class_6880<class_1959>)biome);
                NetherFeatures.modifyNonBNBiome(biomeID, (class_6880<class_1959>)biome);
            }
        });
        BiomeAPI.onFinishingNetherBiomeTags((biomeID, biome) -> {
            if (!biomeID.method_12836().equals("betternether")) {
                NetherStructures.addNonBNBiomeTags(biomeID, (class_6880<class_1959>)biome);
            }
        });
    }

    private static NetherBiome registerNetherBiome(NetherBiomeConfig config) {
        NetherBiome biome = NetherBiomeBuilder.create(config);
        if (biome.getGenChance() > 0.0f) {
            ALL_BN_BIOMES.add(biome);
            BiomeAPI.registerNetherBiome((BCLBiome)biome);
        }
        return biome;
    }

    private static NetherBiome registerNetherBiome(NetherBiomeConfig config, NetherBiomeConfig edgeConfig) {
        NetherBiome edge = NetherBiomeBuilder.create(edgeConfig);
        NetherBiome biome = NetherBiomeBuilder.create(config, edge);
        if (biome.getGenChance() > 0.0f) {
            ALL_BN_BIOMES.add(biome);
            BiomeAPI.registerNetherBiome((BCLBiome)biome);
        }
        if (biome.getEdge() != null && edge.getGenChance() > 0.0f && biome.getEdgeSize() > 0) {
            ALL_BN_BIOMES.add(edge);
            BiomeAPI.registerNetherBiome((BCLBiome)edge);
        }
        return biome;
    }

    private static NetherBiome registerSubBiome(NetherBiomeConfig config, BCLBiome mainBiome) {
        NetherBiome biome = NetherBiomeBuilder.create(config);
        if (biome.getGenChance() > 0.0f) {
            ALL_BN_BIOMES.add(biome);
            BiomeAPI.registerSubBiome((BCLBiome)mainBiome, (BCLBiome)biome, (BiomeAPI.BiomeType)BiomeAPI.BiomeType.BCL_NETHER);
        }
        return biome;
    }

    private static class Config {
        public static final NetherBiomeConfig BIOME_GRAVEL_DESERT = new NetherGravelDesert.Config("Gravel Desert");
        public static final NetherBiomeConfig BIOME_NETHER_JUNGLE = new NetherJungle.Config("Nether Jungle");
        public static final NetherBiomeConfig BIOME_WART_FOREST = new NetherWartForest.Config("Wart Forest");
        public static final NetherBiomeConfig BIOME_GRASSLANDS = new NetherGrasslands.Config("Nether Grasslands");
        public static final NetherBiomeConfig BIOME_MUSHROOM_FOREST = new NetherMushroomForest.Config("Nether Mushroom Forest");
        public static final NetherBiomeConfig BIOME_MUSHROOM_FOREST_EDGE = new NetherMushroomForestEdge.Config("Nether Mushroom Forest Edge");
        public static final NetherBiomeConfig BIOME_WART_FOREST_EDGE = new NetherWartForestEdge.Config("Wart Forest Edge");
        public static final NetherBiomeConfig BIOME_BONE_REEF = new NetherBoneReef.Config("Bone Reef");
        public static final NetherBiomeConfig BIOME_SULFURIC_BONE_REEF = new NetherSulfuricBoneReef.Config("Sulfuric Bone Reef");
        public static final NetherBiomeConfig BIOME_POOR_GRASSLANDS = new NetherPoorGrasslands.Config("Poor Nether Grasslands");
        public static final NetherBiomeConfig NETHER_SWAMPLAND = new NetherSwampland.Config("Nether Swampland");
        public static final NetherBiomeConfig NETHER_SWAMPLAND_TERRACES = new NetherSwamplandTerraces.Config("Nether Swampland Terraces");
        public static final NetherBiomeConfig MAGMA_LAND = new NetherMagmaLand.Config("Magma Land");
        public static final NetherBiomeConfig SOUL_PLAIN = new NetherSoulPlain.Config("Soul Plain");
        public static final NetherBiomeConfig CRIMSON_GLOWING_WOODS = new CrimsonGlowingWoods.Config("Crimson Glowing Woods");
        public static final NetherBiomeConfig OLD_WARPED_WOODS = new OldWarpedWoods.Config("Old Warped Woods");
        public static final NetherBiomeConfig CRIMSON_PINEWOOD = new CrimsonPinewood.Config("Crimson Pinewood");
        public static final NetherBiomeConfig OLD_FUNGIWOODS = new OldFungiwoods.Config("Old Fungiwoods");
        public static final NetherBiomeConfig FLOODED_DELTAS = new FloodedDeltas.Config("Flooded Deltas");
        public static final NetherBiomeConfig UPSIDE_DOWN_FOREST = new UpsideDownForest.Config("Upside Down Forest");
        public static final NetherBiomeConfig UPSIDE_DOWN_FOREST_CLEARED = new UpsideDownForestCleared.Config("upside_down_forest_cleared");
        public static final NetherBiomeConfig OLD_SWAMPLAND = new OldSwampland.Config("Old Swampland");

        private Config() {
        }
    }
}

